

/* Pocket Smalltalk
   Copyright (c) 1998,1999 by Andrew Brault
   http://www.pocketsmalltalk.com
   See LICENSE.TXT for license information */

/* Primitive interface support. */


typedef Object (* Primitive_Function)();

typedef struct {
  int argument_count;
  Primitive_Function function;
} Primitive;


/* Macro for signaling primitive failure */
#define FAIL(n)  fail_code = (n); return Failure_value

/* Max. number of primitives in the VM */
#define PRIMITIVE_COUNT  110

extern int fail_code;

extern const Primitive primitive_table[PRIMITIVE_COUNT];


void * decode_pointer(Object c_pointer);
Object encode_pointer(void * ptr);
                        


/* Collection primitives (in collect.c): */
Object p_array_expanded(Object extra);
Object p_byte_array_expanded(Object extra);
Object p_strstream_nextput(Object character);
Object p_strstream_nextputall(Object string);
Object p_array_copyfrom_to(Object start_index, Object stop_index);
Object p_bytearray_copyfrom_to(Object start_index, Object stop_index);


/* PalmPilot primitives (in pilot.c): */
Object p_set_list_choices(Object choices, Object controlID,
                          Object freeVisibleItems);




